#!perl

use strict;
use Getopt::Long;
use MaterialsScript qw(:all);

#created by HUASUAN-YANG, contact Wechat ID "Nininncole" to learn more

my $hex0="436f707972696768743a204d532d59616e675a68616e5a68616e670a"; 
my $hex1="436f6e7461637420576563686174204944202731333630393631373833372720666f72206d6f726520696e666f2e0a";
my $str1 = pack('H*', $hex0);
my $str2 = pack('H*', $hex1);
print $str1;
print $str2;

my $doc = $Documents{"graphite.xsd"};
$doc->PrimitiveCell;
my $natoms=$doc->SymmetrySystem->NumberOfAtoms;
	
# Converting to a primitive cell can provide a considerable
# gain in productivity. unit: kcal/mol
print "cutoff tot elec_free units: eV/atom\n";
for (my $cutoff=300; $cutoff<800; $cutoff+=50) {
	my $outputData = Modules->CASTEP->Energy->Run($doc,
                          Settings(Quality => "Fine",TheoryLevel=>"GGA",UseCustomEnergyCutoff=>"yes",EnergyCutoff=>"$cutoff"));
#        $outputData->SaveAs("copy_$a.castep");
        my $ene=$outputData->TotalEnergy*0.043361254529175/$natoms;#/23.0609;
        my $ene2=$outputData->FreeEnergy*0.043361254529175/$natoms;#/23.0609;
        print "$cutoff $ene $ene2\n";
}

